/*
* Copyright (C) 2008  Intel Corporation
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License, version 2.1, as published by the Free Software Foundation.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/


#include <DCSApi.h>
#include <ENMApi.h>
#include <stdio.h>
#include <string>
#include <iostream>
using namespace std;

string MacAddressToString(const unsigned char* mac)
{
	int a[6];
	for (int i = 0 ; i < WLAN_MAC_ADDRESS_LENGTH ; i ++)
	{
		a[i] = 0 + mac[i];
	}
	char cMac[18] = {0};
	sprintf(cMac, "%02X:%02X:%02X:%02X:%02X:%02X", a[0], a[1], a[2], a[3], a[4], a[5]);
	return string(cMac);
	//	return wxString::Format(_T("%02X:%02X:%02X:%02X:%02X:%02X"), a[0], a[1], a[2], a[3], a[4], a[5]);
}

int main()
{


	int ret = 0;
	//Initialize the DCS
	ret = DCS_Initialize();

	if(ret==0)
	{
		printf("DCS_initialize SUCCESS\n");

	}else
	{

		printf("DCS_initialize Fail\n");
		return ret;
	}

	ENM_InitUserInfo userInfo;
	memcpy(userInfo.userPath.dcsString, "/tmp", 256);

	/** test ok */
	DCS_InitUserInfo(userInfo);

	/** test ok */
	DCS_SearchAdapter();

	printf("input number\n");
	printf("1 to test startup wired adapter\n");
	printf("2 to test shutdown wired adapter\n");
	printf("3 to test startup wireless adapter\n");
	printf("4 to test shutdown wireless adapter\n");
	printf("5 to get IP on wired adapter\n");
	printf("6 to get IP on wireless adapter\n");
	printf("7 to get type on wired adapter\n");
	printf("8 to get type on wireless adapter\n");
	printf("9 to scan network and get AP list\n");
	printf("10 to connect AP\n");
	printf("11 to enable 802.1x\n");
	printf("12 to disable 802.1x\n");
	printf("13 to set IP\n");
	printf("-1 to quit\n");
	int inputNumber;
	cin >> inputNumber;
	BOOL ifUp;
	while ( inputNumber != -1 )
	{
		switch (inputNumber)
		{
		case 1:
			{
				DCS_UpAdapter(DCS_ADAPTER_WIRED);
				DCS_IsExistUpAdapter(DCS_ADAPTER_WIRED, &ifUp);
				if ( ifUp )
				{
					printf("startup wired adapter successful!\n");
				}
				else
				{
					printf("startup wired adapter failed!\n");
				}
				break;
			}
		case 2:
			{
				DCS_DownAdapter(DCS_ADAPTER_WIRED);
				DCS_IsExistUpAdapter(DCS_ADAPTER_WIRED, &ifUp);
				if ( !ifUp )
				{
					printf("shutdown wired adapter successful!\n");
				}
				else
				{
					printf("shutdown wired adapter failed!\n");
				}
				break;
			}
		case 3:
			{
				DCS_UpAdapter(DCS_ADAPTER_WIREDLESS);
				DCS_IsExistUpAdapter(DCS_ADAPTER_WIREDLESS, &ifUp);
				if ( ifUp )
				{
					printf("startup wireless adapter successful!\n");
				}
				else
				{
					printf("startup wireless adapter failed!\n");
				}
				break;
			}
		case 4:
			{
				DCS_DownAdapter(DCS_ADAPTER_WIREDLESS);
				DCS_IsExistUpAdapter(DCS_ADAPTER_WIREDLESS, &ifUp);
				if ( !ifUp )
				{
					printf("shutdown wireless adapter successful!\n");
				}
				else
				{
					printf("shutdown wireless adapter failed!\n");
				}
				break;
			}
		case 5:
			{
				DCS_DownAdapter(DCS_ADAPTER_WIREDLESS);
				DCS_DownAdapter(DCS_ADAPTER_WIRED);
				DCS_UpAdapter(DCS_ADAPTER_WIRED);
				ENM_String* WiredIP = new ENM_String();
				memset(WiredIP, 0, sizeof(ENM_String));
				DCS_GetIPAddressHLAN(WiredIP);
				if ( 0 == strlen((const char*)WiredIP->dcsString))
				{
					printf("no IP info, exec ifconfig and check it out!\n");
				}
				else
				{
					printf("IP on wired adapter is %s\n", WiredIP->dcsString);
				}
				delete WiredIP;
				break;
			}
		case 6:
			{
				DCS_DownAdapter(DCS_ADAPTER_WIREDLESS);
				DCS_DownAdapter(DCS_ADAPTER_WIRED);
				DCS_UpAdapter(DCS_ADAPTER_WIREDLESS);
				ENM_String* WirelessIP = new ENM_String();
				memset(WirelessIP, 0, sizeof(ENM_String));
				DCS_GetIPAddressHLAN(WirelessIP);
				if ( 0 == strlen((const char*)WirelessIP->dcsString))
				{
					printf("no IP info, exec ifconfig and check it out!\n");
				}
				else
				{
					printf("IP on wireless adapter is %s\n", WirelessIP->dcsString);
				}
				delete WirelessIP;
				break;
			}
		case 7:
			{
				DCS_DownAdapter(DCS_ADAPTER_WIREDLESS);
				DCS_DownAdapter(DCS_ADAPTER_WIRED);
				DCS_UpAdapter(DCS_ADAPTER_WIRED);
				ENM_String* WiredType = new ENM_String();
				memset(WiredType, 0, sizeof(ENM_String));
				DCS_GetConnectTypeHLAN(WiredType);
				if ( 0 == strlen((const char*)WiredType->dcsString))
				{
					printf("sorry, cannot get type info, maybe something wrong happened\n");
				}
				else
				{
					printf("type on wired adapter is %s\n", WiredType->dcsString);
				}
				break;
			}
		case 8:
			{
				DCS_DownAdapter(DCS_ADAPTER_WIREDLESS);
				DCS_DownAdapter(DCS_ADAPTER_WIRED);
				DCS_UpAdapter(DCS_ADAPTER_WIREDLESS);
				ENM_String* WirelessType = new ENM_String();
				memset(WirelessType, 0, sizeof(ENM_String));
				DCS_GetConnectTypeHLAN(WirelessType);
				if ( 0 == strlen((const char*)WirelessType->dcsString))
				{
					printf("sorry, cannot get type info, maybe something wrong happened\n");
				}
				else
				{
					printf("type on wireless adapter is %s\n", WirelessType->dcsString);
				}
				break;
			}
		case 9:
			{
				DCS_UpAdapter(DCS_ADAPTER_WIREDLESS);
				AccessPointList* pOutAPList = new AccessPointList();
				memset(pOutAPList, 0, sizeof(AccessPointList));
				DCS_GetAPList(pOutAPList);
				for (int i = 0; i < pOutAPList->nCount; i++)
				{
					printf("AP name is %s\n", pOutAPList->apList[i].ssid.ucSsid);
					printf("length of name is %d\n", pOutAPList->apList[i].ssid.length);
					printf("type is %d\n", pOutAPList->apList[i].type);
					printf("bssType is %d\n", pOutAPList->apList[i].bssType);
					printf("auth is %d\n", pOutAPList->apList[i].auth);
					printf("signalQuality is %d\n", pOutAPList->apList[i].signalQuality);
					printf("channel is %d\n", pOutAPList->apList[i].channel);
					printf("macAddress is %s\n", MacAddressToString(pOutAPList->apList[i].macAddress).c_str());
					printf("*********************************\n");
				}
				break;
			}
		case 10:
			{
				char apName[256];
				printf("this test only for connect AP without password!\n");
				printf("input ESSID:\n");
				cin >> apName;
				DCS_DownAdapter(DCS_ADAPTER_WIREDLESS);
				DCS_DownAdapter(DCS_ADAPTER_WIRED);
				DCS_UpAdapter(DCS_ADAPTER_WIREDLESS);
				ENM_ConnectAP connectInfo;
				memset(&connectInfo, 0 ,sizeof(ENM_ConnectAP));
				strcpy((char* )connectInfo.key.dcsString, "");
				strcpy((char* )connectInfo.ssid.dcsString, apName);
				connectInfo.auth = 0;
				DCS_ConnectAP(connectInfo);
				printf("now, you can check IP on wireless adapter\n");
				break;
			}
		case 11:
			{
				printf("if u wannna test this method, plz make sure that u have installed XSupplicant in advance, otherwise, it doesn't work!\n");
				printf("after executing, check /etc/init.d/xsupplicant and /etc/default/xsupplicant, u will find ENABLE=1\n");
				DCS_Enable8021xAuthentication(true);
				break;
			}
		case 12:
			{
				printf("if u wannna test this method, plz make sure that u have installed XSupplicant in advance, otherwise, it doesn't work!\n");
				printf("after executing, check /etc/init.d/xsupplicant and /etc/default/xsupplicant, u will find ENABLE=0\n");
				DCS_Enable8021xAuthentication(false);
				break;
			}
		case 13:
			{
				char cIP[256];
				char cMask[256];
				char cGateway[256];
				char cDNS[256];
				DCS_DownAdapter(DCS_ADAPTER_WIRED);
				DCS_DownAdapter(DCS_ADAPTER_WIREDLESS);
				DCS_UpAdapter(DCS_ADAPTER_WIRED);
				printf("input ip:\n");
				cin >> cIP;
				printf("input net mask:\n");
				cin >> cMask;
				printf("input gataway:\n");
				cin >> cGateway;
				printf("input DNS:\n");
				cin >> cDNS;
				ENM_AddressInfo addInfo;
				memset(&addInfo , 0, sizeof(ENM_AddressInfo));
				strcpy((char* )addInfo.ip.dcsString, cIP);
				strcpy((char* )addInfo.mask.dcsString, cMask);
				strcpy((char* )addInfo.gateway.dcsString, cGateway);
				strcpy((char* )addInfo.dns.dcsString, cDNS);
				DCS_SetIPAddress(&addInfo);
				break;
				//                char cHomePage[256];
				//                printf("before you test this method ,plz close all firefox\n");
				//                printf("input homepage, max length is 256:\n");
				//                cin >> cHomePage;
				//                ENM_String* homePage = new ENM_String();
				//                memset(homePage, 0, sizeof(ENM_String));
				//                memcpy(homePage->dcsString, cHomePage, 256);
				//                DCS_OverwriteHomePage(homePage);
				//                delete homePage;
				//                printf("now check it out!\n");
				//                break;
			}
			//            case 14:
			//            {
			//                char cProxy[256];
			//                char cPort[256];
			//                printf("before you test this method ,plz close all firefox\n");
			//                printf("input proxy:\n");
			//                cin >> cProxy;
			//                printf("input port:\n");
			//                cin >> cPort;
			//                ENM_ProxyInfo proxyInfo;
			//                memset(&proxyInfo , 0, sizeof(ENM_ProxyInfo));
			//                strcpy((char* )proxyInfo.host.dcsString, cProxy);
			//                strcpy((char* )proxyInfo.port.dcsString, cPort);
			//                DCS_OverwriteProxy(&proxyInfo);
			//                break;
			//            }
		}

		printf("-----------------------------------------------\n");
		printf("input number\n");
		printf("1 to test startup wired adapter\n");
		printf("2 to test shutdown wired adapter\n");
		printf("3 to test startup wireless adapter\n");
		printf("4 to test shutdown wireless adapter\n");
		printf("5 to get IP on wired adapter\n");
		printf("6 to get IP on wireless adapter\n");
		printf("7 to get type on wired adapter\n");
		printf("8 to get type on wireless adapter\n");
		printf("9 to scan network and get AP list\n");
		printf("10 to connect AP\n");
		printf("11 to enable 802.1x\n");
		printf("12 to disable 802.1x\n");
		printf("13 to set IP\n");
		printf("-1 to quit\n");
		cin >> inputNumber;
	}

	/** test ok */
	//    BOOL ifUp;
	//    DCS_IsExistUpAdapter(DCS_ADAPTER_WIRED, &ifUp);
	//    printf("wired is %d\n", ifUp);
	//
	//    DCS_UpAdapter(DCS_ADAPTER_WIRED);
	//
	//    DCS_IsExistUpAdapter(DCS_ADAPTER_WIRED, &ifUp);
	//    printf("wired is %d\n", ifUp);
	//
	//    DCS_DownAdapter(DCS_ADAPTER_WIRED);
	//
	//    DCS_IsExistUpAdapter(DCS_ADAPTER_WIRED, &ifUp);
	//    printf("wired is %d\n", ifUp);
	//
	//    DCS_IsExistUpAdapter(DCS_ADAPTER_WIREDLESS, &ifUp);
	//    printf("wireless is %d\n", ifUp);
	//
	//    DCS_UpAdapter(DCS_ADAPTER_WIREDLESS);
	//
	//    DCS_IsExistUpAdapter(DCS_ADAPTER_WIREDLESS, &ifUp);
	//    printf("wireless is %d\n", ifUp);
	//
	//    DCS_DownAdapter(DCS_ADAPTER_WIREDLESS);
	//
	//    DCS_IsExistUpAdapter(DCS_ADAPTER_WIREDLESS, &ifUp);
	//    printf("wireless is %d\n", ifUp);
	/** cannot test Wired adapter, because i work on VM, Wireless adapter is ok */
	//    DCS_DownAdapter(DCS_ADAPTER_WIRED);
	//    DCS_DownAdapter(DCS_ADAPTER_WIREDLESS);
	//    DCS_UpAdapter(DCS_ADAPTER_WIREDLESS);
	//    BOOL bIfConnect;
	//    DCS_IsExistConnectAdapter(DCS_ADAPTER_WIREDLESS, &bIfConnect);
	//    printf("bIfConnect is %d\n", bIfConnect);

	/** test ok */
	//    DCS_DownAdapter(DCS_ADAPTER_WIRED);
	//    DCS_DownAdapter(DCS_ADAPTER_WIREDLESS);
	//    DCS_UpAdapter(DCS_ADAPTER_WIREDLESS);
	//    AccessPointList* pOutAPList = new AccessPointList();
	//    memset(pOutAPList, 0, sizeof(AccessPointList));
	//    DCS_GetAPList(pOutAPList);
	//    for (int i = 0; i < pOutAPList->nCount; i++)
	//    {
	//        wcout << "name is " << pOutAPList->apList[i].name << endl;
	//        printf("name is %s\n", pOutAPList->apList[i].ssid.ucSsid);
	//        printf("length is %d\n", pOutAPList->apList[i].ssid.length);
	//        printf("type is %d\n", pOutAPList->apList[i].type);
	//        printf("bssType is %d\n", pOutAPList->apList[i].bssType);
	//        printf("auth is %d\n", pOutAPList->apList[i].auth);
	//        printf("signalQuality is %d\n", pOutAPList->apList[i].signalQuality);
	//        printf("channel is %d\n", pOutAPList->apList[i].channel);
	//        printf("macAddress is %s\n", MacAddressToString(pOutAPList->apList[i].macAddress).c_str());
	//    }

	/** test ok */
	//    DCS_DownAdapter(DCS_ADAPTER_WIRED);
	//    DCS_DownAdapter(DCS_ADAPTER_WIREDLESS);
	//    DCS_UpAdapter(DCS_ADAPTER_WIREDLESS);
	//    APStatus* ap = new APStatus();
	//    memset(ap, 0, sizeof(APStatus));
	//    DCS_GetCurrentAP(ap);
	//    wcout << "name is " << ap->name << endl;
	//    printf("name is %s\n", ap->ssid.ucSsid);
	//    printf("length is %d\n", ap->ssid.length);
	//    printf("type is %d\n", ap->type);
	//    printf("bssType is %d\n", ap->bssType);
	//    printf("auth is %d\n", ap->auth);
	//    printf("signalQuality is %d\n", ap->signalQuality);
	//    printf("channel is %d\n", ap->channel);
	//    printf("macAddress is %s\n", MacAddressToString(ap->macAddress).c_str());

	/** test ok */
	//    DCS_DownAdapter(DCS_ADAPTER_WIREDLESS);
	//    DCS_DownAdapter(DCS_ADAPTER_WIRED);
	//    DCS_UpAdapter(DCS_ADAPTER_WIRED);
	////    DCS_UpAdapter(DCS_ADAPTER_WIREDLESS);
	//    ENM_String* IP = new ENM_String();
	//    memset(IP, 0, sizeof(ENM_String));
	//    DCS_GetIPAddressHLAN(IP);
	//    printf("ip is --%s--\n", IP->dcsString);

	/** cannot test Wired adapter, because i work on VM */
	//    DCS_DownAdapter(DCS_ADAPTER_WIREDLESS);
	//    DCS_DownAdapter(DCS_ADAPTER_WIRED);
	////    DCS_UpAdapter(DCS_ADAPTER_WIRED);
	//    DCS_UpAdapter(DCS_ADAPTER_WIREDLESS);
	//    ENM_String* type = new ENM_String();
	//    memset(type, 0, sizeof(ENM_String));
	//    DCS_GetConnectTypeHLAN(type);
	//    printf("type is --%s--\n", type->dcsString);

	/** need thread when allocating IP dynamically, but it seems that thread cannot work normally */
	//    DCS_DownAdapter(DCS_ADAPTER_WIREDLESS);
	//    DCS_DownAdapter(DCS_ADAPTER_WIRED);
	//    DCS_UpAdapter(DCS_ADAPTER_WIREDLESS);
	//    ENM_ConnectAP connectInfo;
	//    memset(&connectInfo, 0 ,sizeof(ENM_ConnectAP));
	//    strcpy((char* )connectInfo.key.dcsString, "");
	//    strcpy((char* )connectInfo.ssid.dcsString, "ClassmatePC");
	//    connectInfo.auth = 0;
	//    DCS_ConnectAP(connectInfo);

	/** test ok */
	//    DCS_DownAdapter(DCS_ADAPTER_WIREDLESS);
	//    DCS_DownAdapter(DCS_ADAPTER_WIRED);
	//    DCS_UpAdapter(DCS_ADAPTER_WIREDLESS);
	//    ENM_ConnectAP connectInfo;
	//    memset(&connectInfo, 0 ,sizeof(ENM_ConnectAP));
	//    strcpy((char* )connectInfo.key.dcsString, "fdsfsdfsdfs");
	//    strcpy((char* )connectInfo.ssid.dcsString, "ClassmatePC");
	//    connectInfo.auth = 2;
	//    DCS_ConnectAP(connectInfo);
	//    ENM_String* IP = new ENM_String();
	//    memset(IP, 0, sizeof(ENM_String));
	//    DCS_GetIPAddressHLAN(IP);
	//    printf("ip is --%s--\n", IP->dcsString);
	//    printf("it seems that some problems will happen if i startup a thread in DCS, so this method don't run in another thread now\n");

	/** test ok */
	//    DCS_DownAdapter(DCS_ADAPTER_WIREDLESS);
	//    DCS_DownAdapter(DCS_ADAPTER_WIRED);
	//    DCS_UpAdapter(DCS_ADAPTER_WIREDLESS);
	//    ENM_String* IP = new ENM_String();
	//    memset(IP, 0, sizeof(ENM_String));
	//    DCS_GetIPAddressHLAN(IP);
	//    printf("ip is --%s--\n", IP->dcsString);
	//    DCS_CloseWlanConnection();
	//    DCS_GetIPAddressHLAN(IP);
	//    printf("ip is --%s--\n", IP->dcsString);

	/** test ok, this method is independent, could be test derectly after initializing DCS */
	//    printf("if u wannna test this method, plz make sure that u have installed XSupplicant in advance, otherwise, it doesn't work!\n");
	//    printf("after executing, check /etc/init.d/xsupplicant and /etc/default/xsupplicant out, u will see ENABLE=1.\n");
	//    DCS_Enable8021xAuthentication(true);
	//    DCS_Enable8021xAuthentication(false);
	/** test ok */
	//    ENM_String* homePage = new ENM_String();
	//    memset(homePage, 0, sizeof(ENM_String));
	//    memcpy(homePage->dcsString, "www.justsoso11.com", 256);
	//    DCS_OverwriteHomePage(homePage);
	/** test ok */
	//    ENM_ProxyInfo proxyInfo;
	//    memset(&proxyInfo , 0, sizeof(ENM_ProxyInfo));
	//    strcpy((char* )proxyInfo.host.dcsString, "proxy.wangguang");
	//    strcpy((char* )proxyInfo.port.dcsString, "999");
	//    DCS_OverwriteProxy(&proxyInfo);

	/** test ok */
	//    DCS_DownAdapter(DCS_ADAPTER_WIRED);
	//    DCS_DownAdapter(DCS_ADAPTER_WIREDLESS);
	//    DCS_UpAdapter(DCS_ADAPTER_WIRED);
	//    ENM_AddressInfo addInfo;
	//    memset(&addInfo , 0, sizeof(ENM_AddressInfo));
	//    strcpy((char* )addInfo.ip.dcsString, "192.168.140.107");
	//    strcpy((char* )addInfo.mask.dcsString, "255.255.255.128");
	//    strcpy((char* )addInfo.gateway.dcsString, "192.168.140.1");
	//    strcpy((char* )addInfo.dns.dcsString, "123.123.123.123");
	//    DCS_SetIPAddress(&addInfo);

	//    BOOL ifWiredExist;
	//    BOOL ifWirelessExist;
	//    DCS_IsExistUpAdapter(DCS_ADAPTER_WIRED, &ifWiredExist);
	//    DCS_IsExistUpAdapter(DCS_ADAPTER_WIREDLESS, &ifWirelessExist);
	//    printf("wired is %d\n", ifWiredExist);
	//    printf("wireless is %d\n", ifWirelessExist);

	//    ENM_NEIGHBORS_INFO NeighbInfo;
	//    DCS_GetNeighborsInfo(&NeighbInfo);

	//    UINT i;
	//    DCS_GetVersion(&i);
	//    printf("i is %d\n", i);

	ret = DCS_Uninitialize();
	if(ret==0)
	{
		printf("DCS_Uninitialize SUCCESS\n");

		return 0;
	}
	else
	{

		printf("DCS_Uninitialize Fail\n");

		return ret;

	}
	return 0;
}
